/*
 * Decompiled with CFR 0.152.
 */
package xorg.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;
import xorg.springframework.util.LogbackConfigurer;

public abstract class LogbackWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "logbackRefreshInterval";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    public static void initLogging(ServletContext servletContext) {
        String location;
        if (LogbackWebConfigurer.exposeWebAppRoot(servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
            try {
                if (!ResourceUtils.isUrl((String)location)) {
                    location = SystemPropertyUtils.resolvePlaceholders((String)location);
                    location = WebUtils.getRealPath((ServletContext)servletContext, (String)location);
                }
                servletContext.log("Initializing logback from [" + location + "]");
                LogbackConfigurer.initLogging(location);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Invalid 'logbackConfigLocation' parameter: " + ex.getMessage());
            }
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down logback");
        try {
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (LogbackWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

