/*
 * Decompiled with CFR 0.152.
 */
package xorg.springframework.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class LogbackConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String XML_FILE_EXTENSION = ".xml";
    private static LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static JoranConfigurator configurator = new JoranConfigurator();

    public static void initLogging(String location) throws FileNotFoundException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)location);
        URL url = ResourceUtils.getURL((String)resolvedLocation);
        if (resolvedLocation.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            configurator.setContext((Context)lc);
            lc.reset();
            try {
                configurator.doConfigure(url);
            }
            catch (JoranException ex) {
                throw new FileNotFoundException(url.getPath());
            }
            lc.start();
        }
    }

    public static void shutdownLogging() {
        lc.stop();
    }

    public static void setWorkingDirSystemProperty(String key) {
        System.setProperty(key, new File("").getAbsolutePath());
    }
}

