/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.hprose;

import hprose.common.FilterHandler;
import hprose.common.HproseFilter;
import hprose.common.InvokeHandler;
import hprose.io.HproseMode;
import hprose.server.HproseClients;
import hprose.server.HproseHttpService;
import hprose.server.HproseServiceEvent;
import hprose.server.HttpContext;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.web.HttpRequestHandler;

public class HproseHttpServiceExporter
extends RemoteExporter
implements InitializingBean,
HttpRequestHandler {
    private HproseHttpService httpService;
    private boolean crossDomain = true;
    private boolean get = true;
    private boolean p3p = true;
    private boolean debug = true;
    private HproseServiceEvent event = null;
    private HproseMode mode = HproseMode.MemberMode;
    private HproseFilter filter = null;
    private InvokeHandler invokeHandler = null;
    private FilterHandler beforeFilterHandler = null;
    private FilterHandler afterFilterHandler = null;

    public void afterPropertiesSet() throws Exception {
        this.checkService();
        this.checkServiceInterface();
        Object service = this.getService();
        Class cls = this.getServiceInterface();
        this.httpService = new HproseHttpService();
        this.httpService.add(service, cls);
        this.httpService.setCrossDomainEnabled(this.crossDomain);
        this.httpService.setGetEnabled(this.get);
        this.httpService.setP3pEnabled(this.p3p);
        this.httpService.setDebugEnabled(this.debug);
        this.httpService.setEvent(this.event);
        this.httpService.setMode(this.mode);
        this.httpService.setFilter(this.filter);
        this.httpService.use(this.invokeHandler);
        this.httpService.beforeFilter.use(this.beforeFilterHandler);
        this.httpService.afterFilter.use(this.afterFilterHandler);
    }

    public void setCrossDomainEnabled(boolean value) {
        this.crossDomain = value;
    }

    public void setGetEnabled(boolean value) {
        this.get = value;
    }

    public void setP3pEnabled(boolean value) {
        this.p3p = value;
    }

    public void setDebugEnabled(boolean value) {
        this.debug = value;
    }

    public void setEvent(HproseServiceEvent value) {
        this.event = value;
    }

    public void setMode(HproseMode value) {
        this.mode = value;
    }

    public void setFilter(HproseFilter value) {
        this.filter = value;
    }

    public void setInvokeHandler(InvokeHandler value) {
        this.invokeHandler = value;
    }

    public void setBeforeFilterHandler(FilterHandler value) {
        this.beforeFilterHandler = value;
    }

    public void setAfterFilterHandler(FilterHandler value) {
        this.afterFilterHandler = value;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.httpService.handle(new HttpContext((HproseClients)this.httpService, request, response, null, null));
    }
}

