/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util.thrift;

import com.ync365.jrpt.util.thrift.ThriftServiceClientProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ThriftServiceClientProxyFactory
implements FactoryBean,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(ThriftServiceClientProxy.class);
    private Class objectClass;
    private Object proxyClient;
    private String serviceInterface;
    private String serviceName;
    private String host;
    private int timeout = 3000;
    private List<ThriftServiceClientProxy> clients = new CopyOnWriteArrayList<ThriftServiceClientProxy>();
    private List<ThriftServiceClientProxy> alive = new CopyOnWriteArrayList<ThriftServiceClientProxy>();
    private List<ThriftServiceClientProxy> death = new CopyOnWriteArrayList<ThriftServiceClientProxy>();
    private AtomicInteger count = new AtomicInteger(0);
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private int interval = 60000;

    public void afterPropertiesSet() throws Exception {
        String[] hosts;
        for (String address : hosts = this.host.split(",")) {
            String[] tmp2 = address.split(":");
            String ip = tmp2[0];
            int port = Integer.parseInt(tmp2[1]);
            this.serviceName = this.serviceInterface.substring(this.serviceInterface.lastIndexOf(".") + 1);
            ThriftServiceClientProxy client = new ThriftServiceClientProxy(ip, port, this.timeout, this.serviceInterface, this.serviceName);
            try {
                client.init();
                this.alive.add(client);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.death.add(client);
            }
        }
        this.clients.addAll(this.alive);
        this.clients.addAll(this.death);
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ThriftServiceClientProxyFactory.this.check();
            }
        }, 0L, this.interval, TimeUnit.MILLISECONDS);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.objectClass = classLoader.loadClass(this.serviceInterface + "$Iface");
        this.proxyClient = Proxy.newProxyInstance(classLoader, new Class[]{this.objectClass}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                while (ThriftServiceClientProxyFactory.this.alive.size() > 0) {
                    ThriftServiceClientProxy thriftProxy = ThriftServiceClientProxyFactory.this.getThriftServiceClientProxy();
                    try {
                        Object o = method.invoke(thriftProxy.getClient(), args);
                        return o;
                    }
                    catch (InvocationTargetException e1) {
                        Throwable cause = e1.getCause();
                        if (cause instanceof TApplicationException) {
                            throw cause;
                        }
                        if (cause instanceof TTransportException && null != cause) {
                            Throwable causeRoot = cause.getCause();
                            if (causeRoot == null) {
                                throw cause;
                            }
                            if (causeRoot instanceof SocketTimeoutException) {
                                throw cause;
                            }
                        }
                        if (thriftProxy == null) continue;
                        ThriftServiceClientProxy thriftServiceClientProxy = thriftProxy;
                        synchronized (thriftServiceClientProxy) {
                            ThriftServiceClientProxyFactory.this.alive.remove(thriftProxy);
                            ThriftServiceClientProxyFactory.this.death.add(thriftProxy);
                        }
                    }
                    catch (Throwable e) {
                        throw e;
                    }
                }
                throw new Exception("can't invode thrift server cluster.");
            }
        });
    }

    private void check() {
        if (this.clients != null && this.clients.size() > 0) {
            for (ThriftServiceClientProxy item : this.clients) {
                boolean checkResult = item.check();
                if (checkResult) {
                    this.death.remove(item);
                    this.alive.add(item);
                    continue;
                }
                this.alive.remove(item);
                this.death.add(item);
            }
        }
    }

    public ThriftServiceClientProxy getThriftServiceClientProxy() {
        ThriftServiceClientProxy result = null;
        while (this.alive.size() > 0) {
            try {
                int index = this.count.getAndIncrement() % this.alive.size();
                result = this.alive.get(index);
                break;
            }
            catch (IndexOutOfBoundsException e) {
            }
        }
        return result;
    }

    public Object getObject() throws Exception {
        return this.proxyClient;
    }

    public Class getObjectType() {
        return this.objectClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

