/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util.thrift;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServiceClientProxy {
    private static Logger logger = LoggerFactory.getLogger(ThriftServiceClientProxy.class);
    private String ip;
    private int port;
    private int timeout;
    private TProtocol protocol;
    private String serviceInterface;
    private String serviceName;
    private Class objectClass;
    private Object client;

    public ThriftServiceClientProxy(String ip, int port, int timeout, String serviceInterface, String serviceName) {
        this.ip = ip;
        this.port = port;
        this.serviceInterface = serviceInterface;
        this.serviceName = serviceName;
        this.timeout = timeout;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.objectClass = classLoader.loadClass(serviceInterface + "$Iface");
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init() throws Exception {
        TSocket transport = new TSocket(this.ip, this.port);
        transport.setTimeout(this.timeout);
        this.protocol = new TCompactProtocol((TTransport)new TFramedTransport((TTransport)transport));
        try {
            transport.open();
        }
        catch (Exception e) {
            this.protocol = null;
            throw e;
        }
        Class[] parameterTypes = new Class[]{TProtocol.class};
        Constructor<?> constructor = Class.forName(this.serviceInterface + "$Client").getConstructor(parameterTypes);
        Object[] arguments = new Object[]{new TMultiplexedProtocol(this.protocol, this.serviceName)};
        this.client = constructor.newInstance(arguments);
    }

    public boolean isOpen() {
        boolean result = false;
        try {
            result = this.protocol.getTransport().isOpen();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean check() {
        boolean flag = true;
        try {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(this.ip, this.port), 1000);
            s.close();
            if (this.protocol == null) {
                this.init();
            }
        }
        catch (Throwable t) {
            try {
                this.protocol.getTransport().close();
                this.protocol = null;
            }
            finally {
                flag = false;
            }
        }
        return flag;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TProtocol protocol) {
        this.protocol = protocol;
    }

    public Object getClient() {
        return this.client;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftServiceClientProxy other = (ThriftServiceClientProxy)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        return this.port == other.port;
    }
}

