/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util.redis.cluster;

import com.ync365.jrpt.util.redis.cluster.RedisClusterClient;

public class ClusterJedisLock {
    RedisClusterClient client;
    String lockKey;
    int expireMsecs = 60000;
    int timeoutMsecs = 10000;
    boolean locked = false;

    public ClusterJedisLock(RedisClusterClient client, String lockKey) {
        this.client = client;
        this.lockKey = lockKey;
    }

    public ClusterJedisLock(RedisClusterClient client, String lockKey, int timeoutMsecs) {
        this(client, lockKey);
        this.timeoutMsecs = timeoutMsecs;
    }

    public ClusterJedisLock(RedisClusterClient client, String lockKey, int timeoutMsecs, int expireMsecs) {
        this(client, lockKey, timeoutMsecs);
        this.expireMsecs = expireMsecs;
    }

    public ClusterJedisLock(String lockKey) {
        this(null, lockKey);
    }

    public ClusterJedisLock(String lockKey, int timeoutMsecs) {
        this(null, lockKey, timeoutMsecs);
    }

    public ClusterJedisLock(String lockKey, int timeoutMsecs, int expireMsecs) {
        this(null, lockKey, timeoutMsecs, expireMsecs);
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public synchronized boolean acquire() throws InterruptedException {
        return this.acquire(this.client);
    }

    public synchronized boolean acquire(RedisClusterClient client) throws InterruptedException {
        for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
            String oldValueStr;
            long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
            String expiresStr = String.valueOf(expires);
            if (client.setnx(this.lockKey, expiresStr) == 1L) {
                this.locked = true;
                return true;
            }
            String currentValueStr = client.get(this.lockKey);
            if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = client.getSet(this.lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                this.locked = true;
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public synchronized void release() {
        this.release(this.client);
    }

    public synchronized void release(RedisClusterClient client) {
        if (this.locked) {
            client.del(this.lockKey);
            this.locked = false;
        }
    }
}

