/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIExcelUtil {
    public static final String FILE_EXTENSION_XLS = "xls";
    public static final String FILE_EXTENSION_XLSX = "xlsx";

    public static <T> Workbook excelExport(Map<String, String> maps, List<T> list, String type) {
        HSSFWorkbook wb = null;
        try {
            if (type.equals(FILE_EXTENSION_XLS)) {
                wb = new HSSFWorkbook();
            }
            if (type.equals(FILE_EXTENSION_XLSX)) {
                wb = new XSSFWorkbook();
            }
            CreationHelper createHelper = wb.getCreationHelper();
            Sheet sheet = wb.createSheet("sheet1");
            Set<String> sets = maps.keySet();
            Row row = sheet.createRow(0);
            int i = 0;
            for (String key : sets) {
                Cell cell = row.createCell(i++);
                cell.setCellValue(createHelper.createRichTextString(maps.get(key)));
            }
            System.out.println("--------------------100%");
            float avg = (float)list.size() / 20.0f;
            int count = 1;
            for (int j = 0; j < list.size(); ++j) {
                T p = list.get(j);
                Class<?> classType = p.getClass();
                int index = 0;
                Row row1 = sheet.createRow(j + 1);
                for (String key : sets) {
                    String firstLetter = key.substring(0, 1).toUpperCase();
                    String getMethodName = "get" + firstLetter + key.substring(1);
                    Method getMethod = classType.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(p, new Object[0]);
                    Cell cell = row1.createCell(index++);
                    cell.setCellValue(value.toString());
                }
                if ((float)j > avg * (float)count) {
                    ++count;
                    System.out.print("I");
                }
                if (count != 20) continue;
                System.out.print("I100%");
                ++count;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return wb;
    }

    public static Workbook excelExportByMap(Map<String, String> maps, List<Map<String, Object>> list, String type, Map<String, Map<String, String>> format) {
        HSSFWorkbook wb = null;
        try {
            if (type.equals(FILE_EXTENSION_XLS)) {
                wb = new HSSFWorkbook();
            }
            if (type.equals(FILE_EXTENSION_XLSX)) {
                wb = new XSSFWorkbook();
            }
            CreationHelper createHelper = wb.getCreationHelper();
            Sheet sheet = wb.createSheet("sheet1");
            Set<String> sets = maps.keySet();
            Row row = sheet.createRow(0);
            int i = 0;
            for (String key : sets) {
                Cell cell = row.createCell(i++);
                cell.setCellValue(createHelper.createRichTextString(maps.get(key)));
            }
            System.out.println("--------------------100%");
            float avg = (float)list.size() / 20.0f;
            int count = 1;
            for (int j = 0; j < list.size(); ++j) {
                Map<String, Object> p = list.get(j);
                int index = 0;
                Row row1 = sheet.createRow(j + 1);
                for (String key : sets) {
                    Object value = p.get(key);
                    if (null != format && null != format.get(key)) {
                        value = POIExcelUtil.formatString(format.get(key), value.toString());
                    }
                    Cell cell = row1.createCell(index++);
                    cell.setCellValue(value.toString());
                }
                if ((float)j > avg * (float)count) {
                    ++count;
                    System.out.print("I");
                }
                if (count != 20) continue;
                System.out.print("I100%");
                ++count;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        return wb;
    }

    private static String formatString(Map<String, String> format, String value) {
        return format.get(value) != null ? format.get(value) : value;
    }
}

