/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonMapperUtil {
    private static final Logger logger = LoggerFactory.getLogger(JacksonMapperUtil.class);
    private ObjectMapper mapper = new ObjectMapper();
    private static JacksonMapperUtil jacksonMapper = new JacksonMapperUtil();
    private static final int ARRAY_MAX = 1024;

    private JacksonMapperUtil() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static ObjectMapper getInstance() {
        return JacksonMapperUtil.jacksonMapper.mapper;
    }

    public static <T> T jsonToBean(String json, Class<T> valueType) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            return (T)JacksonMapperUtil.getInstance().readValue(json, valueType);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String beanToJson(Object bean) {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = null;
        try {
            gen = new JsonFactory().createJsonGenerator((Writer)sw);
            JacksonMapperUtil.getInstance().writeValue(gen, bean);
            gen.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return sw.toString();
    }

    public static <T> List<T> jsonToList(String json, Class<T> clazz) {
        Object[] t = (Object[])Array.newInstance(clazz, 1024);
        try {
            t = (Object[])JacksonMapperUtil.getInstance().readValue(json, t.getClass());
            return Arrays.asList(t);
        }
        catch (JsonGenerationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Map beanToMap(Object javaBean) {
        Method[] methods;
        HashMap<String, String> result = new HashMap<String, String>();
        for (Method method : methods = javaBean.getClass().getDeclaredMethods()) {
            try {
                if (!method.getName().startsWith("get")) continue;
                String field = method.getName();
                field = field.substring(field.indexOf("get") + 3);
                field = field.toLowerCase().charAt(0) + field.substring(1);
                Object value = method.invoke(javaBean, (Object[])null);
                result.put(field, null == value ? "" : value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Map jsonToMap(String jsonString) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator iterator = jsonObject.keys();
            String key = null;
            String value = null;
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                value = jsonObject.getString(key);
                result.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String listToJson(List<?> t) {
        try {
            return JacksonMapperUtil.getInstance().writeValueAsString(t);
        }
        catch (JsonGenerationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

