/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static Map convertBean(Object bean) {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                returnMap.put(propertyName, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnMap;
    }

    public static Object convertMap(Class type, Map map) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            Object obj = type.newInstance();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName)) continue;
                Object value = map.get(propertyName);
                Object[] args = new Object[]{value};
                descriptor.getWriteMethod().invoke(obj, args);
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyProperties(Object source, Object target) {
        try {
            BeanUtils.copyProperties((Object)target, (Object)source);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public static List copyList(Object sourList, Class clazz) {
        List sObjs;
        ArrayList dObjs = new ArrayList();
        if (sourList instanceof List && (sObjs = (List)sourList) != null && !sObjs.isEmpty()) {
            for (Object sObj : sObjs) {
                try {
                    Object dObj = clazz.newInstance();
                    BeanUtil.copyProperties(sObj, dObj);
                    dObjs.add(dObj);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return dObjs;
    }
}

