package com.ync365.jrpt.service.pagination;

import java.io.Serializable;

/**
 * 分页DTO<br> 
 */
public class PaginationDTO implements Serializable {

    private static final long serialVersionUID = -7133686187861357139L;
    /**
     * 总共结果数量
     */
    private Integer           total            = 0;
    /**
     * 每页结果数量
     */
    private Integer           pageSize         = 5;
    /**
     * 目前第几页，下标从1开始
     */
    private Integer           pageNo           = 1;
    /**
     * 返回结果封装集
     */
    private Object               items;
    /**
     * 请求连接，主要用于分页组件
     */
    private String               action;
    
    /**
     * 获取总共结果数量
     * @return total 总共结果数量
     */
    public Integer getTotal() {
        return total;
    }
    /**
     * 设置总共结果数量
     * @param total 总共结果数量
     */
    public void setTotal(Integer total) {
        this.total = total;
    }
    /**
     * 获取每页结果数量
     * @return pageSize 每页结果数量
     */
    public Integer getPageSize() {
        return pageSize;
    }
    /**
     * 设置每页结果数量
     * @param pageSize 每页结果数量
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
    /**
     * 获取目前第几页，下标从1开始
     * @return pageNo 目前第几页，下标从1开始
     */
    public Integer getPageNo() {
        return pageNo;
    }
    /**
     * 设置目前第几页，下标从1开始
     * @param pageNo 目前第几页，下标从1开始
     */
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }
	public Object getItems() {
		return items;
	}
	public void setItems(Object items) {
		this.items = items;
	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
}
