package com.ync365.jrpt.service.common;

/**
 * 
 * 中台接口业务异常
 */
public class UicException extends RuntimeException {

    private static final long serialVersionUID = -2425434978689960713L;
    private String            errorCode;
    private Object[]          errorMessage;

    /**
     * 业务定义的异常
     * 
     * @param errorCode
     * @param errorMessage
     */
    public UicException(Throwable e) {
        super(e);
    }

    /**
     * 业务定义的异常
     * 
     * @param errorCode
     * @param errorMessage
     */
    public UicException(String errorCode, Object... errorMessage) {
        super();
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    /**
     * 业务捕捉的异常
     * 
     * @param e
     * @param errorCode
     * @param errorMessage
     */
    public UicException(Throwable e, String errorCode, Object... errorMessage) {
        super(e);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object[] getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(Object[] errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getMessage() {
            return "中台接口异常";
    }
}
