package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzProductInfoDTO;
import com.ync365.jrpt.service.pagination.PageDTO;
import com.ync365.jrpt.service.pagination.PageRequestDTO;

/**
 * <b>功能描述：产品搜索接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface SearchService {
    
    /**
     * 
     * 功能描述: 产品搜索
     * 
     * @param keyword  搜索词
     * @param pageNo  页数 默认为1
     * @param pageSize 页面大小 默认为10
     * @return ResponseDTO<PageDTO<JnzProductInfoDTO>>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<PageDTO<JnzProductInfoDTO>> search(String keyword,Integer pageNo,Integer pageSize);
    
    /**
     * 
     * 功能描述: 产品搜索,默认返回第一页,十条
     * 
     * @param keyword 搜索词
     * @return ResponseDTO<PageDTO<JnzProductInfoDTO>>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<PageDTO<JnzProductInfoDTO>> search(String keyword);
    
    /**
     * 
     * 功能描述:获取搜索历史 
     * @return ResponseDTO<List<String>>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<String>> getSearchHistory();
}
