package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzUserTradeOrderDTO;
import com.ync365.jrpt.service.dto.requestdto.JnzUserTradeOrderRequestDTO;

/**
 * <b>功能描述：交易订单接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserTradeOrderService {
    
    /**
     * 
     * 功能描述: 获取用户
     * 
     * @param type 1 持有 2已转出
     * @param pageNo
     * @param pageSize
     * @return ResponseDTO<List<JnzUserTradeOrderDTO>>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<List<JnzUserTradeOrderDTO>> getUserOrderList(Integer type,Integer pageNo,Integer pageSize);

    /**
     * 
     * 功能描述: 增加订单
     * 
     * @param jnzUserTradeOrderRequestDTO
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> insert(JnzUserTradeOrderRequestDTO jnzUserTradeOrderRequestDTO);
}
