package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzUserTradeLogDTO;
import com.ync365.jrpt.service.dto.requestdto.JnzUserTradeLogRequestDTO;
import com.ync365.jrpt.service.pagination.PageDTO;
import com.ync365.jrpt.service.pagination.PageRequestDTO;

/**
 * <b>功能描述：交易日志接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserTradeLogService {


    /**
     * 
     * 功能描述: 查询用户交易列表
     * 
     * @param tradeType 交易类型
     * @param pageNo 页码
     * @param pageSize 页面尺寸大小
     * @return ResponseDTO<List<JnzUserTradeLogRequestDTO>>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<List<JnzUserTradeLogDTO>> getTradeLogService(Integer tradeType,Integer pageNo,Integer pageSize);
    
    /**
     * 功能描述: 查询用户交易列表
     * @param jnzUserTradeLogDTO
     * @param orderByClause
     * @param pageRequest
     * @return
     */
    ResponseDTO<PageDTO<JnzUserTradeLogDTO>> getTradeLogByPage(JnzUserTradeLogDTO jnzUserTradeLogDTO,String orderByClause, PageRequestDTO pageRequest);

}
