package com.ync365.jrpt.service;

import cfca.etl.uaserver.vo.request.BankCardValidateVO;
import cfca.etl.uaserver.vo.response.BankCardStatusVO;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.common.ResultDTO;
import com.ync365.jrpt.service.dto.JnzUserInfoDTO;
import com.ync365.jrpt.service.dto.requestdto.JnzCaAuthRequestDTO;
import com.ync365.jrpt.util.BankCardUtil;

/**
 * <b>功能描述：用户信息接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserInfoService {
    /**
     * 
     * 功能描述: 根据用户名查询用户
     * 
     * @param userName
     * @return ResponseDTO<JnzUserInfoDTO>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<JnzUserInfoDTO> findUserByLoginName(String userName);
    /**
     * 
     * 功能描述: 根据用户手机号查询用户信息
     * 
     * @param mobile
     * @return ResponseDTO<JnzUserInfoDTO>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<JnzUserInfoDTO> findUserByMobile(String mobile);
    
    /**
     * 
     * 功能描述: 根据用户编码查询用户信息
     * 
     * @param mobile
     * @return ResponseDTO<JnzUserInfoDTO>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<JnzUserInfoDTO> findUserByUserId(Integer userId);
    /**
     * 
     * 功能描述:获取用户信息 
     * 
     * @return ResponseDTO<JnzUserInfoDTO>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<JnzUserInfoDTO> getUserInfo();
    
    /**
     * 
     * 功能描述: 忘记密码获取手机号验证码
     * 
     * @param phone
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<Boolean> getForgetPasswordCode(String phone);
    /**
     * 
     * 功能描述: 检测验证码是否正确
     * 
     * @param phone
     * @param valCode
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<ResultDTO> checkPhoneCode(String phone,String valCode);
    /**
     * 
     * 功能描述: 忘记密码修改密码
     * 
     * @param token 上一步返回的token值
     * @param valCode 短信验证码
     * @param newPassword 新密码
     * @param confirmPassword 确认密码
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<Boolean> forgetPasswordCode(String token,String newPassword,String confirmPassword);
    
    /**
     * 
     * 功能描述: 修改密码
     * 
     * @param userId
     * @param password
     * @param newPassword
     * @param confirmPassword
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> updatePassword(String password , String newPassword ,String confirmPassword);
    
    /**
     * 功能描述: 修改密码
     * @param userId
     * @param password
     * @param newPassword
     * @param confirmPassword
     * @return
     */
    ResponseDTO<Boolean> updatePassword(Integer userId,String password , String newPassword ,String confirmPassword);
    
    /**
     * 
     * 功能描述: 实名认证
     * 
     * @param realName
     * @param idCard
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> realNameAuthentication(String realName, String idCard);
    
    /**
     * 
     * 功能描述: 证书认证
     * 
     * @param jnzCaAuthRequestDTO
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> caAuthentication(JnzCaAuthRequestDTO jnzCaAuthRequestDTO);
    /**
     * 实名认证
     * @param bankCardValidateVO
     * @return
     */
    ResponseDTO<BankCardStatusVO> realAuth(BankCardValidateVO bankCardValidateVO);
}
