package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzUserBankCardDTO;
import com.ync365.jrpt.service.dto.requestdto.JnzUserBankCardRequestDTO;

/**
 * <b>功能描述：用户银行卡接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserBankCardService {
    
    /**
     * 
     * 功能描述: 根据userid获取用户银行卡列表
     * 
     * @param userId
     * @return ResponseDTO<List<JnzUserBankCardDTO>>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<List<JnzUserBankCardDTO>> getUserBankCard(Integer userId);
    
    /**
     * 
     * 功能描述: 获取用户银行卡列表
     * 
     * @return ResponseDTO<List<JnzUserBankCardDTO>>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<List<JnzUserBankCardDTO>> getUserBankCard();
    
    /**
     * 
     * 功能描述: 获取手机号验证码
     * 
     * @param phone
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> getUserBankCardCode(String phone);

    /**
     * 
     * 功能描述: 添加银行卡
     * 
     * @param jnzUserBankCardDTO
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<Boolean> addUserBankCard(JnzUserBankCardRequestDTO jnzUserBankCardRequestDTO);
}
