package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzShufflingFigureDTO;

/**
 * 
 * 功能描述: 广告轮播图
 *
 * @date 2016-11-10
 * @since 1.0.0
 * @version 1.0.0
 * @author 徐大伟
 */
public interface JnzShufflingFigureService {
    /**
     * 
     * 功能描述: 获取广告轮播图 -- 通用接口
     * 
     * @param positionId 位置编码
     * @param clientType 客户端类型
     * @param pageSize 数量
     * @return ResponseDTO<List<JnzShufflingFigureDTO>>
     * @date 2016-11-9
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzShufflingFigureDTO>> getShufflingFigure(Integer positionId,String clientType,Integer pageSize);
    /**
     * 
     * 功能描述: 手机端轮播图
     * 
     * @return ResponseDTO<List<JnzShufflingFigureDTO>>
     * @date 2016-11-9
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzShufflingFigureDTO>> getAppBanner();
    
    /**
     * 
     * 功能描述: 手机端广告
     * 
     * @return ResponseDTO<List<JnzShufflingFigureDTO>>
     * @date 2016-11-9
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzShufflingFigureDTO>> getAppAd();
}
