package com.ync365.jrpt.service;

import com.ync365.jrpt.service.common.ResponseDTO;

/**
 * 
 * 功能描述: 注册接口
 * 
 * @version 1.0.0
 * @author 王佳田
 */
public interface JnzRegisterService {
    
    /**
     * 
     * 功能描述: 检查手机号是否注册过
     * 
     * @param phone 手机号
     * @return ResponseDTO<Boolean> 
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<Boolean> checkPhone(String phone); 

    /**
     * 
     * 功能描述: 手机号获取验证码
     * 
     * @param phone 手机号
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<Boolean> getPhoneCode(String phone);
    
    /**
     * 
     * 功能描述: 检验手机号和验证码是否正确
     * 
     * @param phone 手机号
     * @param code 验证码
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<Boolean> checkPhoneCode(String phone,String code);
    
    /**
     * 
     * 功能描述: 注册
     * 
     * @param phone 手机号
     * @param password 密码
     * @return ResponseDTO<Boolean>
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<Boolean> register(String phone,String password);
}
