package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzProductInfoDTO;
import com.ync365.jrpt.service.dto.requestdto.ProductParamRequestDTO;
import com.ync365.jrpt.service.pagination.PageDTO;
import com.ync365.jrpt.service.pagination.PageRequestDTO;

/**
 * <b>功能描述：理财产品接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzProductInfoService {

 
    /**
     * 
     * 功能描述: 理财推荐
     * @param pageRequestDTO 分页信息
     * @return ResponseDTO<PageDTO<JnzProductInfoDTO>>
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<PageDTO<JnzProductInfoDTO>> getRecommendProduct(PageRequestDTO pageRequestDTO,List<ProductParamRequestDTO> paramlist);
    /**
     * 
     * 功能描述: 理财推荐
     * 
     * @param pageNo  当前页数
     * @param pageSize 页面大小
     * @return ResponseDTO<List<JnzProductInfoDTO>>
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzProductInfoDTO>> getRecommendProduct(Integer pageNo,Integer pageSize);
    
    /**
     * 
     * 功能描述: 产品列表
     * 
     * @param pageRequestDTO 分页信息
     * @return ResponseDTO<PageDTO<JnzProductInfoDTO>>
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<PageDTO<JnzProductInfoDTO>> getProductList(String orderByClause,PageRequestDTO pageRequestDTO,List<ProductParamRequestDTO> paramlist);
    
    /**
     * 
     * 功能描述:  产品列表
     * 
     * @param orderName 排序字段 1综合排序 2产品收益 3产品期限
     * @param orderType 排序方式 1升序 2降序
     * @param pageNo
     * @param pageSize
     * @return ResponseDTO<List<JnzProductInfoDTO>>
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzProductInfoDTO>> getProductList(Integer orderName,Integer orderType ,Integer pageNo,Integer pageSize,List<ProductParamRequestDTO> paramlist);
    
    /**
     * 
     * 功能描述: 查看产品详情
     * 
     * @param productId 产品编号
     * @return ResponseDTO<JnzProductInfoDTO>
     * @date 2016-11-10
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<JnzProductInfoDTO> getProduct(Integer productId);
    
    /**
     * 功能描述: 查询理财产品列表
     * @param paramlist 参数列表
     * @param JnzProductInfoDTO
     * @param orderByClause
     * @param pageRequestDTO
     * @return
     */
	ResponseDTO<PageDTO<JnzProductInfoDTO>> getProductInfoListByPage(JnzProductInfoDTO JnzProductInfoDTO, Integer orderName,Integer orderType,PageRequestDTO pageRequestDTO,List<ProductParamRequestDTO> paramlist);
}
