package com.ync365.jrpt.service;

import java.util.List;
import java.util.Map;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzPositionDTO;

/**
 * <b>功能描述：栏目管理接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzPositionService {
    
    /**
     * 
     * 功能描述: 查询栏目信息 
     * 
     * @param positionType  位置类型 1:通用位置 2:广告位置
     * @param clientType    客户端类型(逗号分隔) 1:pc,2:手机',
     * @return List<Map<String,Object>> 
     * @since  1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<Map<String, Object>>> findPositionByList(Integer positionType,String clientType);
    
    /**
     * 
     * 功能描述: 查询栏目信息 
     * 
     * @return ResponseDTO<List<JnzPositionDTO>>
     * @date 2016-11-9
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    ResponseDTO<List<JnzPositionDTO>> getAppPositionList();
}
