package com.ync365.jrpt.service;

import java.util.List;
import java.util.Map;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzNewsDTO;
import com.ync365.jrpt.service.pagination.PageDTO;
import com.ync365.jrpt.service.pagination.PageRequestDTO;

/**
 * <b>功能描述：资讯接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzNewsService {

    /**
     * 
     * 功能描述: 查询资讯列表
     * 
     * @param pageSize 每页数量
     * @param pageNo 页数
     * @return PageDTO<Map<String,Object>>  
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<List<JnzNewsDTO>> list(Integer pageNo,Integer pageSize); 
    
    /**
     * 
     * 功能描述: 查询资讯详情
     * 
     * @param id   资讯主键
     * @return Map<String,Object>
     * @version 1.0.0
     * @author 王佳田
     */
    public ResponseDTO<JnzNewsDTO> loadById(Integer id); 
    
    /**
     * 分页查询资讯列表
     * @param jnzNews
     * @param orderByClause
     * @param pageRequest
     * @return
     */
    public ResponseDTO<PageDTO<Map<String, Object>>> findJnzNewsListByPage(JnzNewsDTO jnzNews,String orderByClause,PageRequestDTO pageRequest);
    
}
