package com.ync365.jrpt.service;

import java.util.List;
import java.util.Map;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.JnzMsgDTO;
import com.ync365.jrpt.service.pagination.PageDTO;
import com.ync365.jrpt.service.pagination.PageRequestDTO;

/**
 * <b>功能描述：消息接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzMsgService {
    
    /**
     * 
     * 功能描述: 查询消息列表
     * 
     * @param pageNo
     * @param pageSize
     * @return ResponseDTO<List<JnzMsgDTO>>
     * @version 1.0.0
     * @author 王佳田
     */
    ResponseDTO<List<JnzMsgDTO>> getMsgList(Integer pageNo, Integer pageSize);
    
    /**
     * 功能描述: 查询消息列表(PC)
     * @param jnzMsg
     * @param orderByClause
     * @param pageRequest
     * @return
     */
    ResponseDTO<PageDTO<Map<String, Object>>> findJnzMsgListByPage(JnzMsgDTO jnzMsg,String orderByClause,PageRequestDTO pageRequest);

}
