package com.ync365.jrpt.service;

import java.util.List;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.BasicBankInfoDTO;

/**
 * <b>功能描述：银行基础信息接口
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface BasicBankInfoService {
    
    /**
     * 
     * 功能描述:分页获取银行列表 
     * 
     * @param pageNo
     * @param pageSize
     * @return ResponseDTO<List<BasicBankInfoDTO>>
     * @version 1.0.0
     * @author 徐大伟
     */
    public ResponseDTO<List<BasicBankInfoDTO>> getBanksList(Integer pageNo,Integer pageSize);
    
    /**
     * 
     * 功能描述:获取所有银行 
     * 
     * @return ResponseDTO<List<BasicBankInfoDTO>>
     * @version 1.0.0
     * @author 徐大伟
     */
    public ResponseDTO<List<BasicBankInfoDTO>> getBanksList();
    
    /**
     * 
     * 功能描述: 根据卡号获取所属银行
     * 
     * @param cardNo
     * @return ResponseDTO<BasicBankInfoDTO>
     * @version 1.0.0
     * @author 徐大伟
     */
    public ResponseDTO<BasicBankInfoDTO> getBankByCardNo(String cardNo);

}
