package com.ync365.jrpt.service;

import com.ync365.jrpt.service.common.ResponseDTO;
import com.ync365.jrpt.service.dto.AreasDTO;
import java.util.List;

/**
 * 地区查询
 *
 * @author yangwenqi
 * @version v1.0
 */
public interface AreasService
{

    /**
     * 加载省
     *
     * @return
     */
    public ResponseDTO<List<AreasDTO>> getProvince();

    /**
     * 加载市
     *
     * @param provinceId
     * @return
     */
    public ResponseDTO<List<AreasDTO>> getCity(String provinceId);

    /**
     * 加载县
     *
     * @param cityId
     * @return
     */
    public ResponseDTO<List<AreasDTO>> getCounty(String cityId);

    /**
     * 加载乡镇街道
     *
     * @param countyId
     * @return
     */
    public ResponseDTO<List<AreasDTO>> getTown(String countyId);

    /**
     * 加载社区及村庄
     *
     * @param townId
     * @return
     */
    public ResponseDTO<List<AreasDTO>> getVillage(String townId);
    
    /**
     * 加载完整的地区，适用于前台页面 select
     * 
     * @param childrenId 
     * @return 
     */
    public ResponseDTO<List<AreasDTO>> getSelectByChild(String childrenId);

}
