/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.pagination;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class PageRequest
implements Serializable {
    private static final long serialVersionUID = -7630528785190715459L;
    protected int pageNo = 1;
    protected int pageSize = 10;
    protected String orderBy = null;
    protected String orderDir = null;
    protected boolean countTotal = true;

    public PageRequest() {
    }

    public PageRequest(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 1;
        }
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderDir() {
        return this.orderDir;
    }

    public void setOrderDir(String orderDir) {
        String lowcaseOrderDir = StringUtils.lowerCase((String)orderDir);
        Object[] orderDirs = StringUtils.split((String)lowcaseOrderDir, (char)',');
        if (ArrayUtils.isEmpty((Object[])orderDirs)) {
            return;
        }
        for (Object orderDirStr : orderDirs) {
            if (StringUtils.equals((CharSequence)"desc", (CharSequence)orderDirStr) || StringUtils.equals((CharSequence)"asc", (CharSequence)orderDirStr)) continue;
            throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + (String)orderDirStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
        }
        this.orderDir = lowcaseOrderDir;
    }

    public List<Sort> getSort() {
        String[] orderDirs;
        if (this.orderBy == null || this.orderDir == null) {
            return Collections.EMPTY_LIST;
        }
        String[] orderBys = StringUtils.split((String)this.orderBy, (char)',');
        Assert.isTrue((orderBys.length == (orderDirs = StringUtils.split((String)this.orderDir, (char)',')).length ? 1 : 0) != 0, (String)"\u5206\u9875\u591a\u91cd\u6392\u5e8f\u53c2\u6570\u4e2d,\u6392\u5e8f\u5b57\u6bb5\u4e0e\u6392\u5e8f\u65b9\u5411\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49");
        ArrayList<Sort> orders = new ArrayList<Sort>();
        for (int i = 0; i < orderBys.length; ++i) {
            orders.add(new Sort(orderBys[i], orderDirs[i]));
        }
        return orders;
    }

    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((CharSequence)this.orderBy) && StringUtils.isNotBlank((CharSequence)this.orderDir);
    }

    public boolean isCountTotal() {
        return this.countTotal;
    }

    public void setCountTotal(boolean countTotal) {
        this.countTotal = countTotal;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public String getOrderSortString() {
        List<Sort> list = this.getSort();
        StringBuffer buffer = new StringBuffer();
        for (Sort sort : list) {
            buffer.append(sort.property + " " + sort.dir).append(",");
        }
        return StringUtils.substringBeforeLast((String)buffer.toString(), (String)",");
    }

    public static class Sort {
        public static final String ASC = "asc";
        public static final String DESC = "desc";
        private final String property;
        private final String dir;

        public Sort(String property, String dir) {
            this.property = property;
            this.dir = dir;
        }

        public String getProperty() {
            return this.property;
        }

        public String getDir() {
            return this.dir;
        }
    }
}

