/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.pagination;

import com.ync365.jrpt.business.pagination.PageRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page<T>
extends PageRequest
implements Serializable {
    protected List<T> rows = null;
    protected int total = 0;
    protected int totalPages = 0;
    protected int prePage = 0;
    protected int nextPage = 0;

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public Page() {
    }

    public Page(PageRequest request) {
        this.pageNo = request.getPageNo();
        this.pageSize = request.getPageSize();
        this.countTotal = request.isCountTotal();
        this.orderBy = request.getOrderBy();
        this.orderDir = request.getOrderDir();
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotalPages() {
        this.totalPages = (int)Math.ceil((double)this.total / (double)this.getPageSize());
        return this.totalPages < 1 ? 1 : this.totalPages;
    }

    public boolean hasNextPage() {
        return this.getPageNo() + 1 <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.hasNextPage()) {
            this.nextPage = this.getPageNo() + 1;
            return this.nextPage;
        }
        this.nextPage = this.getPageNo();
        return this.nextPage;
    }

    public boolean hasPrePage() {
        return this.getPageNo() > 1;
    }

    public int getPrePage() {
        if (this.hasPrePage()) {
            this.prePage = this.getPageNo() - 1;
            return this.prePage;
        }
        this.prePage = this.getPageNo();
        return this.prePage;
    }

    public List<Integer> getSlider(int count) {
        int halfSize = count / 2;
        int totalPage = this.getTotalPages();
        int startPageNo = Math.max(this.getPageNo() - halfSize, 1);
        int endPageNo = Math.min(startPageNo + count - 1, totalPage);
        if (endPageNo - startPageNo < count) {
            startPageNo = Math.max(endPageNo - count, 1);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPageNo; i <= endPageNo; ++i) {
            result.add(i);
        }
        return result;
    }
}

