/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.job.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.TriggerBuilder;

public class JobWrapper {
    private Class<Job> actualJobClass;
    private String cronExpression;
    private String jobName;
    private String jobGroup = "DEFAULT";
    private String triggerName;
    private String triggerGroup = "DEFAULT";
    private Scheduler scheduler;
    private boolean shouldRecover = false;
    private boolean replace = false;

    public void init() throws Exception {
        if (this.jobName == null) {
            this.jobName = this.actualJobClass.getSimpleName();
        }
        if (this.triggerName == null) {
            this.triggerName = this.actualJobClass.getSimpleName();
        }
        JobDetail job = JobBuilder.newJob(this.actualJobClass).withIdentity(this.jobName, this.jobGroup).requestRecovery(this.shouldRecover).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.triggerName, this.triggerGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression)).build();
        HashMap triggersAndJobs = new HashMap();
        HashMap triggersAndJob = new HashMap();
        ArrayList<CronTrigger> triggers = new ArrayList<CronTrigger>();
        HashSet<CronTrigger> triggerset = new HashSet<CronTrigger>();
        triggerset.add(trigger);
        triggers.add(trigger);
        triggersAndJob.put(job, triggerset);
        this.scheduler.scheduleJobs(triggersAndJob, this.replace);
    }

    public void setJobClass(Class jobClass) {
        this.actualJobClass = jobClass != null && !Job.class.isAssignableFrom(jobClass) ? jobClass : jobClass;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerGroup() {
        return this.triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isShouldRecover() {
        return this.shouldRecover;
    }

    public void setShouldRecover(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }
}

