/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.job.common;

import com.ync365.jrpt.business.job.common.BaseJob;
import com.ync365.jrpt.business.job.common.JobAndTrigger;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.stereotype.Service;

@Service
public class JobBiz
extends BaseJob {
    private Scheduler scheduler;

    public void initJob(Scheduler scheduler) {
    }

    public void addTrigger(JobAndTrigger jobAndTrigger) {
        long start = System.currentTimeMillis();
        JobKey jobKey = new JobKey(jobAndTrigger.getJobName(), jobAndTrigger.getJobGroup().toString());
        TriggerKey triggerKey = new TriggerKey(jobAndTrigger.getTriggerName(), jobAndTrigger.getTriggerGroup().toString());
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(jobAndTrigger.getStartDate()).forJob(jobKey).usingJobData(jobAndTrigger.getJobDataMap()).build();
        try {
            if (this.scheduler.checkExists(triggerKey)) {
                this.scheduler.unscheduleJob(triggerKey);
            }
            this.scheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        long end = System.currentTimeMillis();
        this.logger.info("the time of baseJob\uff1a" + (end - start) / 1000L + "seconds");
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

