/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.biz;

import com.ync365.jrpt.business.biz.BaseBiz;
import com.ync365.jrpt.business.dao.PositionDao;
import com.ync365.jrpt.business.dao.entity.JnzPosition;
import com.ync365.jrpt.business.dao.entity.Position;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PositionBiz
extends BaseBiz {
    @Autowired
    private PositionDao positionDao;

    public List<Position> selectAll() {
        return this.positionDao.selectAll();
    }

    public List<Map<String, Object>> selectedCheck(Integer sid) {
        return this.positionDao.selectedCheck(sid);
    }

    public Page<Map<String, Object>> findPositionByPage(Position position, PageRequest pageRequest) {
        List<Map<String, Object>> list = this.findPositionByList(position, pageRequest);
        int total = this.findPositionByCount(position);
        return PageBuilder.buildPage(pageRequest, list, total);
    }

    public List<Map<String, Object>> findPositionByList(Position position, PageRequest pageRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", position.getName());
        map.put("positionType", position.getPositionType());
        map.put("status", position.getStatus());
        map.put("clientType", position.getClientType());
        map.put("offset", pageRequest.getOffset());
        map.put("limit", pageRequest.getPageSize());
        return this.positionDao.findPositionList(map);
    }

    public List<Map<String, Object>> findPositionByList(Position position) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", position.getName());
        map.put("positionType", position.getPositionType());
        map.put("status", position.getStatus());
        map.put("clientType", position.getClientType());
        return this.positionDao.findPositionList(map);
    }

    public Integer findPositionByCount(Position position) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", position.getName());
        map.put("positionType", position.getPositionType());
        map.put("status", position.getStatus());
        map.put("clientType", position.getClientType());
        return this.positionDao.findPositionByCount(map);
    }

    public boolean power(Integer id, Integer status) {
        return this.positionDao.power(id, status) > 0;
    }

    public List<JnzPosition> getAppPositionList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", "1");
        map.put("clientType", "2");
        return this.positionDao.getAppPositionList(map);
    }
}

