/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.biz;

import com.ync365.jrpt.business.biz.BaseBiz;
import com.ync365.jrpt.business.dao.JnzUserAssetDao;
import com.ync365.jrpt.business.dao.JnzUserInfoDao;
import com.ync365.jrpt.business.dao.entity.JnzUserAsset;
import com.ync365.jrpt.business.dao.entity.JnzUserInfo;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import com.ync365.jrpt.util.DateUtil;
import com.ync365.jrpt.util.EncryptUtil;
import com.ync365.jrpt.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jnzUserInfoBiz")
public class JnzUserInfoBiz
extends BaseBiz {
    private static final Logger logger = Logger.getLogger(JnzUserInfoBiz.class);
    @Autowired
    private JnzUserInfoDao jnzUserInfoDao;
    @Autowired
    private JnzUserAssetDao jnzUserAssetDao;

    public List<Map<String, Object>> queryJnzUserInfoByList(JnzUserInfo jnzUserInfo, String orderByClause, int pageNo, int pageSize, String startDate, String endDate) {
        String limitClause = "";
        if (pageNo != 0 && pageSize != 0) {
            limitClause = "limit " + (pageNo - 1) * pageSize + "," + pageSize;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("jnzUserInfo", jnzUserInfo);
        paraMap.put("orderByClause", orderByClause);
        paraMap.put("limitClause", limitClause);
        if (StringUtil.isEmpty((String)startDate)) {
            paraMap.put("startDate", startDate);
        } else {
            paraMap.put("startDate", DateUtil.buildMinOfDate((Date)DateUtil.str2Date((String)startDate)));
        }
        if (StringUtil.isEmpty((String)endDate)) {
            paraMap.put("endDate", endDate);
        } else {
            paraMap.put("endDate", DateUtil.buildMaxOfDate((Date)DateUtil.str2Date((String)endDate)));
        }
        return this.jnzUserInfoDao.queryJnzUserInfoByList(paraMap);
    }

    public Integer queryJnzUserInfoByCount(JnzUserInfo jnzUserInfo, String startDate, String endDate) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("jnzUserInfo", jnzUserInfo);
        if (StringUtil.isEmpty((String)startDate)) {
            paraMap.put("startDate", startDate);
        } else {
            paraMap.put("startDate", DateUtil.buildMinOfDate((Date)DateUtil.str2Date((String)startDate)));
        }
        if (StringUtil.isEmpty((String)endDate)) {
            paraMap.put("endDate", endDate);
        } else {
            paraMap.put("endDate", DateUtil.buildMinOfDate((Date)DateUtil.str2Date((String)endDate)));
        }
        return this.jnzUserInfoDao.queryJnzUserInfoByCount(paraMap);
    }

    public Map<String, Object> queryJnzUserInfoById(Integer id) {
        return this.jnzUserInfoDao.queryJnzUserInfoById(id);
    }

    public JnzUserInfo queryJnzUserInfoByUserId(Integer userId) {
        return this.jnzUserInfoDao.queryJnzUserInfoByUserId(userId);
    }

    public Integer deleteJnzUserInfoById(Integer id) {
        return this.jnzUserInfoDao.deleteJnzUserInfoById(id);
    }

    public Integer updateJnzUserInfoBySelective(JnzUserInfo jnzUserInfo) {
        return this.jnzUserInfoDao.updateJnzUserInfoBySelective(jnzUserInfo);
    }

    public Integer updatePassword(JnzUserInfo jnzUserInfo) {
        return this.jnzUserInfoDao.updatePassword(jnzUserInfo);
    }

    @Transactional
    public Integer insertJnzUserInfoSelective(JnzUserInfo jnzUserInfo) {
        this.jnzUserInfoDao.insertJnzUserInfoSelective(jnzUserInfo);
        JnzUserAsset jnzUserAsset = new JnzUserAsset();
        jnzUserAsset.setUserId(jnzUserInfo.getId());
        jnzUserAsset.setTotalAssets(new BigDecimal(0.0));
        jnzUserAsset.setTotalProfit(new BigDecimal(0.0));
        jnzUserAsset.setUserPhone(jnzUserInfo.getUserPhone());
        return this.jnzUserAssetDao.insertJnzUserAssetSelective(jnzUserAsset);
    }

    public Integer insertJnzUserInfo(JnzUserInfo jnzUserInfo) {
        return this.jnzUserInfoDao.insertJnzUserInfo(jnzUserInfo);
    }

    public Page<Map<String, Object>> findJnzUserInfoListByPage(JnzUserInfo jnzUserInfo, String orderByClause, PageRequest pageRequest, String startDate, String endDate) {
        List<Map<String, Object>> list = this.queryJnzUserInfoByList(jnzUserInfo, orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize(), startDate, endDate);
        Integer total = this.queryJnzUserInfoByCount(jnzUserInfo, startDate, endDate);
        return PageBuilder.buildPage(pageRequest, list, total);
    }

    public int batchDeleteJnzUserInfo(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<String> idsList = new ArrayList<String>();
        for (String item : idArray) {
            idsList.add(item);
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", idsList);
        int r1 = this.jnzUserInfoDao.batchDeleteJnzUserInfo(paraMap);
        return r1;
    }

    public int batchFreezeJnzUserInfo(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<String> idsList = new ArrayList<String>();
        for (String item : idArray) {
            idsList.add(item);
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", idsList);
        int r1 = this.jnzUserInfoDao.batchFreezeJnzUserInfo(paraMap);
        return r1;
    }

    public Map<String, Object> findUserByPwdAndUserName(String userName, String pwd) {
        pwd = EncryptUtil.getMd5((String)pwd);
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("userName", userName);
        paraMap.put("userPassword", pwd);
        return this.jnzUserInfoDao.findUserByPwdAndUserName(paraMap);
    }

    public JnzUserInfo findUserByUserName(String userName) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("userName", userName);
        return this.jnzUserInfoDao.findUserByUserName(paraMap);
    }

    public JnzUserInfo findUserByMobile(String mobile) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("userPhone", mobile);
        return this.jnzUserInfoDao.findUserByUserName(paraMap);
    }
}

