/*
 * Decompiled with CFR 0.152.
 */
package com.ync365.jrpt.business.biz;

import com.ync365.jrpt.business.dao.JnzNewsDao;
import com.ync365.jrpt.business.dao.entity.JnzNews;
import com.ync365.jrpt.business.enums.NewsPubEnum;
import com.ync365.jrpt.business.pagination.Page;
import com.ync365.jrpt.business.pagination.PageBuilder;
import com.ync365.jrpt.business.pagination.PageRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jnzNewsBiz")
public class JnzNewsBiz {
    private static final Logger logger = Logger.getLogger(JnzNewsBiz.class);
    @Autowired
    private JnzNewsDao jnzNewsDao;

    public List<Map<String, Object>> queryJnzNewsByList(JnzNews jnzNews, String orderByClause, int pageNo, int pageSize) {
        String limitClause = "";
        if (pageNo != 0 && pageSize != 0) {
            limitClause = "limit " + (pageNo - 1) * pageSize + "," + pageSize;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("jnzNews", jnzNews);
        paraMap.put("orderByClause", orderByClause);
        paraMap.put("limitClause", limitClause);
        return this.jnzNewsDao.queryJnzNewsByList(paraMap);
    }

    public Integer queryJnzNewsByCount(JnzNews jnzNews) {
        HashMap<String, JnzNews> paraMap = new HashMap<String, JnzNews>();
        paraMap.put("jnzNews", jnzNews);
        return this.jnzNewsDao.queryJnzNewsByCount(paraMap);
    }

    public Map<String, Object> queryJnzNewsById(Integer id) {
        return this.jnzNewsDao.queryJnzNewsById(id);
    }

    public Integer deleteJnzNewsById(Integer id) {
        return this.jnzNewsDao.deleteJnzNewsById(id);
    }

    public Integer updateJnzNewsBySelective(JnzNews jnzNews) {
        return this.jnzNewsDao.updateJnzNewsBySelective(jnzNews);
    }

    public Integer insertJnzNewsSelective(JnzNews jnzNews) {
        return this.jnzNewsDao.insertJnzNewsSelective(jnzNews);
    }

    public Integer insertJnzNews(JnzNews jnzNews) {
        return this.jnzNewsDao.insertJnzNews(jnzNews);
    }

    public Page<Map<String, Object>> findJnzNewsListByPage(JnzNews jnzNews, String orderByClause, PageRequest pageRequest) {
        List<Map<String, Object>> list = this.queryJnzNewsByList(jnzNews, orderByClause, pageRequest.getPageNo(), pageRequest.getPageSize());
        Integer total = this.queryJnzNewsByCount(jnzNews);
        return PageBuilder.buildPage(pageRequest, list, total);
    }

    public int batchDeleteJnzNews(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<String> idsList = new ArrayList<String>();
        for (String item : idArray) {
            idsList.add(item);
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", idsList);
        int r1 = this.jnzNewsDao.batchDeleteJnzNews(paraMap);
        return r1;
    }

    @Transactional
    public int batchPubNews(String ids) {
        String[] idArray;
        int i = 0;
        for (String item : idArray = ids.split(",")) {
            Map<String, Object> map = this.jnzNewsDao.queryJnzNewsById(Integer.parseInt(item));
            if (null != map) {
                JnzNews jnzNews = new JnzNews();
                jnzNews.setId(MapUtils.getInteger(map, (Object)"id"));
                Integer pub = MapUtils.getInteger(map, (Object)"isPub");
                if (pub.equals(NewsPubEnum.PUB.getValue())) {
                    jnzNews.setIsPub(NewsPubEnum.CANCEL_PUB.getValue());
                } else {
                    jnzNews.setIsPub(NewsPubEnum.PUB.getValue());
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-DD HH:MM:SS");
                    jnzNews.setPubTime(sdf.format(new Date()));
                }
                this.jnzNewsDao.updateJnzNewsBySelective(jnzNews);
            }
            ++i;
        }
        return i;
    }
}

