/*
 * Decompiled with CFR 0.152.
 */
package com.ucpaas.restDemo.client;

import com.ucpaas.restDemo.EncryptUtil;
import com.ucpaas.restDemo.SSLHttpClient;
import com.ucpaas.restDemo.SysConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public abstract class AbsRestClient {
    public boolean isTest = Boolean.parseBoolean(SysConfig.getInstance().getProperty("is_test"));
    public String server = SysConfig.getInstance().getProperty("rest_server");
    public String sslIP = SysConfig.getInstance().getProperty("http_ssl_ip");
    public int sslPort = SysConfig.getInstance().getPropertyInt("http_ssl_port");
    public String version = SysConfig.getInstance().getProperty("version");
    private static Logger logger = Logger.getLogger(AbsRestClient.class);

    public abstract String findAccoutInfo(String var1, String var2) throws NoSuchAlgorithmException, KeyManagementException;

    public abstract String createClient(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract String findClients(String var1, String var2, String var3, String var4, String var5);

    public abstract String findClientByNbr(String var1, String var2, String var3, String var4);

    public abstract String closeClient(String var1, String var2, String var3, String var4);

    public abstract String charegeClient(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract String billList(String var1, String var2, String var3, String var4);

    public abstract String clientBillList(String var1, String var2, String var3, String var4, String var5);

    public abstract String callback(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract String voiceCode(String var1, String var2, String var3, String var4, String var5);

    public abstract String templateSMS(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract String findClientByMobile(String var1, String var2, String var3, String var4);

    public abstract String dispalyNumber(String var1, String var2, String var3, String var4, String var5);

    public StringBuffer getStringBuffer() {
        StringBuffer sb = new StringBuffer("https://");
        sb.append(this.server);
        return sb;
    }

    public DefaultHttpClient getDefaultHttpClient() {
        DefaultHttpClient httpclient = null;
        if (this.isTest) {
            try {
                SSLHttpClient chc = new SSLHttpClient();
                httpclient = chc.registerSSL(this.sslIP, "TLS", this.sslPort, "https");
                BasicHttpParams hParams = new BasicHttpParams();
                hParams.setParameter("https.protocols", (Object)"SSLv3,SSLv2Hello");
                httpclient.setParams((HttpParams)hParams);
            }
            catch (KeyManagementException e) {
                logger.error((Object)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e);
            }
        } else {
            httpclient = new DefaultHttpClient();
        }
        return httpclient;
    }

    public String getSignature(String accountSid, String authToken, String timestamp, EncryptUtil encryptUtil) throws Exception {
        String sig = accountSid + authToken + timestamp;
        String signature = encryptUtil.md5Digest(sig);
        return signature;
    }

    public HttpResponse get(String cType, String accountSid, String authToken, String timestamp, String url, DefaultHttpClient httpclient, EncryptUtil encryptUtil) throws Exception {
        HttpGet httppost = new HttpGet(url);
        httppost.setHeader("Accept", cType);
        httppost.setHeader("Content-Type", cType + ";charset=utf-8");
        String src = accountSid + ":" + timestamp;
        String auth = encryptUtil.base64Encoder(src);
        httppost.setHeader("Authorization", auth);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        return response;
    }

    public HttpResponse post(String cType, String accountSid, String authToken, String timestamp, String url, DefaultHttpClient httpclient, EncryptUtil encryptUtil, String body) throws Exception {
        HttpPost httppost = new HttpPost(url);
        httppost.setHeader("Accept", cType);
        httppost.setHeader("Content-Type", cType + ";charset=utf-8");
        String src = accountSid + ":" + timestamp;
        String auth = encryptUtil.base64Encoder(src);
        httppost.setHeader("Authorization", auth);
        BasicHttpEntity requestBody = new BasicHttpEntity();
        requestBody.setContent((InputStream)new ByteArrayInputStream(body.getBytes("UTF-8")));
        requestBody.setContentLength((long)body.getBytes("UTF-8").length);
        httppost.setEntity((HttpEntity)requestBody);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        return response;
    }

    public HttpResponse delete(String cType, String accountSid, String authToken, String timestamp, String url, DefaultHttpClient httpclient, EncryptUtil encryptUtil) throws Exception {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setHeader("Accept", cType);
        httpDelete.setHeader("Content-Type", cType + ";charset=utf-8");
        String src = accountSid + ":" + timestamp;
        String auth = encryptUtil.base64Encoder(src);
        httpDelete.setHeader("Authorization", auth);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
        return response;
    }

    public HttpResponse put(String cType, String accountSid, String authToken, String timestamp, String url, DefaultHttpClient httpclient, EncryptUtil encryptUtil, String body) throws Exception {
        HttpPut httpPut = new HttpPut(url);
        httpPut.setHeader("Accept", cType);
        httpPut.setHeader("Content-Type", cType + ";charset=utf-8");
        String src = accountSid + ":" + timestamp;
        String auth = encryptUtil.base64Encoder(src);
        httpPut.setHeader("Authorization", auth);
        logger.info((Object)body);
        BasicHttpEntity requestBody = new BasicHttpEntity();
        requestBody.setContent((InputStream)new ByteArrayInputStream(body.getBytes("UTF-8")));
        requestBody.setContentLength((long)body.getBytes("UTF-8").length);
        httpPut.setEntity((HttpEntity)requestBody);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPut);
        return response;
    }
}

