package com.ync365.jrpt.business.job.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

/**
 * 此类用来自动注入job到quartz的scheduler里面 必须是多例模式，否则属性冲突
 * 
 * @author piaohailin
 * @date 2013-5-2
 */
public class JobWrapper {
    private Class<Job> actualJobClass;
    private String     cronExpression;
    private String     jobName;
    private String     jobGroup      = "DEFAULT";
    private String     triggerName;
    private String     triggerGroup  = "DEFAULT";
    private Scheduler  scheduler;
    private boolean    shouldRecover = false;
    private boolean    replace       = false;

    /**
     * 初始化方法
     * 
     * @author piaohailin
     * @date 2013-5-2
     */
    public void init() throws Exception {
        if (jobName == null) {
            jobName = actualJobClass.getSimpleName();
        }
        if (triggerName == null) {
            triggerName = actualJobClass.getSimpleName();
        }

        JobDetail job = JobBuilder.newJob(actualJobClass).withIdentity(jobName, jobGroup).requestRecovery(shouldRecover).build();
        CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroup).withSchedule(CronScheduleBuilder.cronSchedule(cronExpression)).build();
        Map<JobDetail, List<Trigger>> triggersAndJobs = new HashMap<JobDetail, List<Trigger>>();
        Map<JobDetail, Set<? extends Trigger>> triggersAndJob = new HashMap<JobDetail, Set<? extends Trigger>>();
        List<Trigger> triggers = new ArrayList<Trigger>();
        Set<Trigger> triggerset = new HashSet<Trigger>();
        triggerset.add(trigger);
        triggers.add(trigger);
//        triggersAndJobs.put(job, triggers);
        triggersAndJob.put(job, triggerset);
        scheduler.scheduleJobs(triggersAndJob, replace);
    }

    /**
     * 
     * @param jobClass jobClass
     * @author piaohailin
     * @date 2013-5-2
     */
    public void setJobClass(Class jobClass) {
        if (jobClass != null && !Job.class.isAssignableFrom(jobClass)) {
            this.actualJobClass = jobClass;
        } else {
            this.actualJobClass = jobClass;
        }
    }

    /**
     * @return the jobName
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * @param jobName the jobName to set
     */
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * @return the jobGroup
     */
    public String getJobGroup() {
        return jobGroup;
    }

    /**
     * @param jobGroup the jobGroup to set
     */
    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    /**
     * @return the triggerName
     */
    public String getTriggerName() {
        return triggerName;
    }

    /**
     * @param triggerName the triggerName to set
     */
    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    /**
     * @return the triggerGroup
     */
    public String getTriggerGroup() {
        return triggerGroup;
    }

    /**
     * @param triggerGroup the triggerGroup to set
     */
    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    /**
     * @return the cronExpression
     */
    public String getCronExpression() {
        return cronExpression;
    }

    /**
     * @param cronExpression the cronExpression to set
     */
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    /**
     * @return the scheduler
     */
    public Scheduler getScheduler() {
        return scheduler;
    }

    /**
     * @param scheduler the scheduler to set
     */
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /**
     * @return the shouldRecover
     */
    public boolean isShouldRecover() {
        return shouldRecover;
    }

    /**
     * @param shouldRecover the shouldRecover to set
     */
    public void setShouldRecover(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    public boolean isReplace() {
        return replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }
}
