package com.ync365.jrpt.business.job.common;

import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * job biz<br>
 * 
 * @author 管阳
 */
@Service
public class JobBiz extends BaseJob {


    private Scheduler     scheduler;

    /**
     * JOB初始化 功能描述: <br>
     * 〈功能详细描述〉
     * 
     * @param scheduler
     * @see [相关类/方法](可选)
     * @since [产品/模块版本](可选)
     */
    public void initJob(Scheduler scheduler) {
        // 测试
//        try {
//            JobDetail jobDetail = JobBuilder.newJob(TestJob.class).withIdentity("TEST1", "TESTGROUP1").storeDurably(true).requestRecovery(false).build();
//            scheduler.addJob(jobDetail, true);
//        } catch (SchedulerException e) {
//            logger.error(e.getMessage(),e);
//        }

    }

    /**
     * 功能描述: 添加trigger<br>
     * JobAndTrigger属性定义参照属性说明
     * @param scheduler 调度实例
     * @param jobAndTrigger job数据对象配置
     */
    public void addTrigger(JobAndTrigger jobAndTrigger) {
        long start = System.currentTimeMillis();
        JobKey jobKey = new JobKey(jobAndTrigger.getJobName(), jobAndTrigger.getJobGroup().toString());
        /******* trigger *********/
        TriggerKey triggerKey = new TriggerKey(jobAndTrigger.getTriggerName(), jobAndTrigger.getTriggerGroup().toString());
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(jobAndTrigger.getStartDate()).forJob(jobKey).usingJobData(jobAndTrigger.getJobDataMap()).build();
        try {
            if (scheduler.checkExists(triggerKey)) {
                scheduler.unscheduleJob(triggerKey);
            }
            scheduler.scheduleJob(trigger);
        } catch (SchedulerException e) {
            logger.error(e.getMessage(),e);
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        long end = System.currentTimeMillis();
        logger.info("the time of baseJob：" + (end - start) / 1000 + "seconds");
    }


    public Scheduler getScheduler() {
        return scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}
