package com.ync365.jrpt.business.job.common;

import java.util.Date;

import org.quartz.Job;
import org.quartz.JobDataMap;

/**
 * job数据对象配置<br>
 *
 * @author 管阳
 */
public class JobAndTrigger {

    /**
     * job名称，必须定义，格式：拍品ID_拍卖ID ，活动ID
     */
    private String               jobName;
    /**
     * job组，必须定义
     */
    private JobGroupEnum         jobGroup;
    /**
     * trigger名称，必须定义，格式：拍品ID_拍卖ID ，活动ID
     */
    private String               triggerName;
    /**
     * trigger组，必须定义
     */
    private TriggerGroupEnum     triggerGroup;
    /**
     * job所需数据
     */
    private JobDataMap           jobDataMap = new JobDataMap();
    /**
     * Job实现类，必须定义
     */
    private Class<? extends Job> jobClass;
    /**
     * 触发时间，必须定义
     */
    private Date                 startDate;
    /**
     * cron表达式，定义CronTrigger时使用
     */
    private String               cronExpression;

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public JobDataMap getJobDataMap() {
        return jobDataMap;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public Class<? extends Job> getJobClass() {
        return jobClass;
    }

    public void setJobClass(Class<? extends Job> jobClass) {
        this.jobClass = jobClass;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public JobGroupEnum getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(JobGroupEnum jobGroup) {
        this.jobGroup = jobGroup;
    }

    public TriggerGroupEnum getTriggerGroup() {
        return triggerGroup;
    }

    public void setTriggerGroup(TriggerGroupEnum triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Override
    public String toString() {
        return "JobAndTrigger [jobName=" + jobName + ", jobGroup=" + jobGroup + ", triggerName=" + triggerName + ", triggerGroup=" + triggerGroup + ", jobDataMap=" + jobDataMap + ", jobClass=" + jobClass + ", startDate=" + startDate + ", cronExpression=" + cronExpression + "]";
    }

}
