package com.ync365.jrpt.business.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperFileUtil {
	
    public static void readFileByIO(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = fis.read(buffer)) != -1) {
                System.out.write(buffer, 0, len);
            }
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            try {
                fis.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public static String readByNIO(String file) {
        //第一步 获取通道
        FileInputStream fis = null;
        FileChannel channel = null;
        String re = null;
        try {
            fis = new FileInputStream(file);
            channel = fis.getChannel();
            //文件内容的大小
            int size = (int) channel.size();

            //第二步 指定缓冲区
            ByteBuffer buffer = ByteBuffer.allocate(1024*1024);
            //第三步 将通道中的数据读取到缓冲区中
            channel.read(buffer);

            Buffer bf = buffer.flip();
            System.out.println("limt:" + bf.limit());

            byte[] bt = buffer.array();
            re = new String(bt, 0, size,"UTF-8");

            buffer.clear();
            buffer = null;
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            try {
                channel.close();
                fis.close();

            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }
        return re;
    }

    /**
     * 利用NIO将内容输出到文件中
     * @param file
     */
    public static void writeFileByNIO(String file) {
        FileOutputStream fos = null;
        FileChannel fc = null;
        ByteBuffer buffer = null;
        try {
            fos = new FileOutputStream(file);
            //第一步 获取一个通道
            fc = fos.getChannel();
            //buffer=ByteBuffer.allocate(1024);
            //第二步 定义缓冲区
            buffer = ByteBuffer.wrap("Hello World 2".getBytes());
            //将内容写到缓冲区
            fos.flush();
            fc.write(buffer);

        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            try {
                fc.close();
                fos.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }
    }

    
    /** 
     * 以行为单位读取文件，常用于读面向行的格式化文件 
      */
    public static void readFileByLines(String fileName) {
        File file = new File(fileName);
        BufferedReader reader = null;
        try {
            System.out.println(" 以行为单位读取文件内容，一次读一整行： ");
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            int line = 1;
            //  一次读入一行，直到读入null为文件结束  
            while ((tempString = reader.readLine()) != null) {
                //  显示行号  
                System.out.println(" line  " + line + " :  " + tempString);
                line++;
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e1) {
                }
            }
        }
    }
	
}
