package com.ync365.jrpt.business.enums;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValueEnumUtils
{

    /**
     * 通过字典枚举获取数据字典集合
     *
     * @param enumClass 枚举 class
     * @return List
     */
    public static List<Map<Object, Object>> getEnums(Class<? extends Enum<? extends ValueEnum<?>>> enumClass)
    {
        List<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
        Enum<?>[] values = enumClass.getEnumConstants();
        Map<Object, Object> map = null;
        for (Enum<?> o : values)
        {
            ValueEnum<?> ve = (ValueEnum<?>) o;
            Object value = ve.getValue();

            map = new LinkedHashMap<Object, Object>();
            map.put("value", value);
            map.put("key", ve.getName());
            result.add(map);

        }
        return result;
    }

    /**
     * 功能描述: 查看枚举中是否有指定的value
     *
     * @param enumClass
     * @param value
     * @return Boolean
     */
    public static Boolean checkValueInEnum(Class<? extends Enum<? extends ValueEnum<?>>> enumClass, String value)
    {
        Enum<?>[] values = enumClass.getEnumConstants();
        for (Enum<?> o : values)
        {
            ValueEnum<?> ve = (ValueEnum<?>) o;
            if (value.equals(ve.getValue()))
            {
                return true;
            }
        }
        return false;
    }

}
