package com.ync365.jrpt.business.enums;
/**
 * 用户类型枚举
 *
 */
public enum UserTypeEnum implements ValueEnum<String>{
	SM("SM","系统管理员"),
	SE("SE","服务工程师"),
	FM("FM","财务管理员"),
	WM("WM","运维工程师"),
	SEL("SEL","SE负责人");

	UserTypeEnum(String value,String name) {
		this.name = name;
		this.value = value;
	}
	
	private String name;
	
	private String value;
	
	@Override
	public String getValue() {
		return value;
	}

	@Override
	public String getName() {
		return name;
	}
	
}
