package com.ync365.jrpt.business.enums;

/**
 * 基金枚举
 *
 * @author yangwenqi
 * @version v1.0
 */
public enum FundEnum implements ValueEnum<String>
{

    HUAXIA("huaxia", "华夏基金"),
    YINHUA("yinhua", "银华基金"),
    CAILUTONG("cailutong", "财路通");

    FundEnum(String value, String name)
    {
        this.name = name;
        this.value = value;
    }

    private String name;

    private String value;

    @Override
    public String getValue()
    {
        return value;
    }

    @Override
    public String getName()
    {
        return name;
    }

}
