package com.ync365.jrpt.business.enums;
/**
 * 用户类型枚举
 *
 */
public enum BankEnum implements ValueEnum<String>{
	CCB("CCB","中国建设银行"),
	ICBC("ICBC","中国工商银行"),
	BOC("BOC","中国银行"),
	CMB("CMB","招商银行"),
	CIB("CIB","兴业银行"),
	BCM("BCM","交通银行"),
	CEB ("CEB1","中国光大银行"),
	GDB("GDB","中国光大银行"),
	ABC("ABC1","广东发展银行"),
	SPDB("SPDB","上海浦东发展银行");

	BankEnum(String value,String name) {
		this.name = name;
		this.value = value;
	}
	
	private String name;
	
	private String value;
	
	@Override
	public String getValue() {
		return value;
	}

	@Override
	public String getName() {
		return name;
	}
	
}
