package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.dao.entity.JnzPosition;
import com.ync365.jrpt.business.dao.entity.Position;

public interface PositionDao {

    List<Position> selectAll();

    List<Map<String, Object>> selectedCheck(Integer sid);
    
    Integer deleteAllBySid(Integer sid);
    
    /**
     * 页面位置列表
     * @param map
     * @return
     */
	List<Map<String, Object>> findPositionList(Map<String, Object> map);
	/**
	 * 统计页面位置数量
	 * @param map
	 * @return
	 */
	Integer findPositionByCount(Map<String, Object> map);

	Integer power(@Param("id")Integer id, @Param("status")Integer status);
	/**
	 * 
	 * 功能描述: 查询手机端栏目信息
	 * 
	 * @param map 
	 * @return List<JnzPosition>
	 * @date 2016-11-9
	 * @since 1.0.0
	 * @version 1.0.0
	 * @author 徐大伟
	 */
    List<JnzPosition> getAppPositionList(Map<String, Object> map);
}