package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzVersion;


/**
 * <b>功能描述：系统版本Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzVersionDao {
	/**
	 * <b>功能描述：查询系统版本列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzVersionByList(Map map); 
	/**
	 * <b>功能描述：查询系统版本列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzVersionByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询系统版本信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzVersionById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzVersionById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzVersionBySelective(JnzVersion jnzVersion);
	/**
	 * <b>功能描述：新增系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzVersionSelective(JnzVersion jnzVersion);
	/**
	 * <b>功能描述：新增系统版本
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzVersion(JnzVersion jnzVersion);
	
	    /**
     * 
     * 功能描述: 批量删除系统版本
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzVersion(Map<String, Object> paraMap);
}
