package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzUserTradeOrder;


/**
 * <b>功能描述：交易订单Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserTradeOrderDao {
	/**
	 * <b>功能描述：查询交易订单列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserTradeOrderByList(Map map); 
	
	/**
	 * 
	 * 功能描述: 查询用户订单带产品信息
	 * 
	 * @param map
	 * @return List<Map<String,Object>>
	 * @version 1.0.0
	 * @author 王佳田
	 */
	public List<Map<String,Object>> queryUserOrderWithProduct(Map map);
	/**
	 * <b>功能描述：查询交易订单列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserTradeOrderByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询交易订单信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserTradeOrderById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserTradeOrderById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserTradeOrderBySelective(JnzUserTradeOrder jnzUserTradeOrder);
	/**
	 * <b>功能描述：新增交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeOrderSelective(JnzUserTradeOrder jnzUserTradeOrder);
	/**
	 * <b>功能描述：新增交易订单
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeOrder(JnzUserTradeOrder jnzUserTradeOrder);
	
	    /**
     * 
     * 功能描述: 批量删除交易订单
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzUserTradeOrder(Map<String, Object> paraMap);
    
    public List<Map<String, Object>> queryUserSavingStatics(@Param("year")String year);
}
