package com.ync365.jrpt.business.dao;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.dao.entity.JnzUserTradeLog;


/**
 * <b>功能描述：交易日志Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserTradeLogDao {
	/**
	 * <b>功能描述：查询交易日志列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserTradeLogByList(Map map); 
	/**
	 * <b>功能描述：查询交易日志列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserTradeLogByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询交易日志信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserTradeLogById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserTradeLogById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserTradeLogBySelective(JnzUserTradeLog jnzUserTradeLog);
	/**
	 * <b>功能描述：新增交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeLogSelective(JnzUserTradeLog jnzUserTradeLog);
	/**
	 * <b>功能描述：新增交易日志
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserTradeLog(JnzUserTradeLog jnzUserTradeLog);
	
	    /**
     * 
     * 功能描述: 批量删除交易日志
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzUserTradeLog(Map<String, Object> paraMap);
    
    /**
     * 
     * 功能描述: 查询用户昨日收益
     * 
     * @param userId
     * @return BigDecimal
     * @version 1.0.0
     * @author 王佳田
     */
    public BigDecimal findUserYesterdayProfit(@Param("userId")Integer userId);
    /**
     * 
     * 功能描述: 查询用户本月回款总额
     * 
     * @param userId
     * @return BigDecimal
     * @version 1.0.0
     * @author 王佳田
     */
    public BigDecimal findUserMothPayment(@Param("userId")Integer userId);
}
