package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.dao.entity.JnzUserInfo;


/**
 * <b>功能描述：用户信息Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserInfoDao {
	/**
	 * <b>功能描述：查询用户信息列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserInfoByList(Map map); 
	/**
	 * <b>功能描述：查询用户信息列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserInfoByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询用户信息信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserInfoBySelective(JnzUserInfo jnzUserInfo);
	/**
	 * 
	 * 功能描述:修改密码 
	 * 
	 * @param jnzUserInfo
	 * @return Integer
	 * @version 1.0.0
	 * @author 徐大伟
	 */
	public Integer updatePassword(JnzUserInfo jnzUserInfo);
	/**
	 * <b>功能描述：新增用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserInfoSelective(JnzUserInfo jnzUserInfo);
	/**
	 * <b>功能描述：新增用户信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserInfo(JnzUserInfo jnzUserInfo);
	
	    /**
     * 
     * 功能描述: 批量删除用户信息
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzUserInfo(Map<String, Object> paraMap);
    
    /**
     * 
     * 功能描述: 批量冻结用户信息
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchFreezeJnzUserInfo(Map<String, Object> paraMap);
    
    /**
     * 
     * 功能描述: 登录
     * 
     * @param paraMap
     * @return Map<String,Object>
     * @version 1.0.0
     * @author 王佳田
     */
    public Map<String, Object> findUserByPwdAndUserName(Map<String, Object> paraMap);
    
    /**
     * 
     * 功能描述:根据ID查询用户信息(前台) 
     * 
     * @param userId
     * @return JnzUserInfo
     * @version 1.0.0
     * @author 徐大伟
     */
    public JnzUserInfo queryJnzUserInfoByUserId(@Param("userId")Integer userId);
    
    /**
     * 
     * 功能描述:根据用户名用户信息(前台) 
     * 
     * @param userName
     * @return JnzUserInfo
     * @version 1.0.0
     * @author 徐大伟
     */
    public JnzUserInfo findUserByUserName(Map<String, Object> paraMap);
}
