package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzUserBankCard;


/**
 * <b>功能描述：用户银行卡Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserBankCardDao {
	/**
	 * <b>功能描述：查询用户银行卡列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserBankCardByList(Map map); 
	/**
	 * <b>功能描述：查询用户银行卡列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserBankCardByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询用户银行卡信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserBankCardById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserBankCardById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserBankCardBySelective(JnzUserBankCard jnzUserBankCard);
	/**
	 * <b>功能描述：新增用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserBankCardSelective(JnzUserBankCard jnzUserBankCard);
	/**
	 * <b>功能描述：新增用户银行卡
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserBankCard(JnzUserBankCard jnzUserBankCard);
	
	    /**
     * 
     * 功能描述: 批量删除用户银行卡
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzUserBankCard(Map<String, Object> paraMap);
}
