package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzUserAsset;


/**
 * <b>功能描述：用户资产Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzUserAssetDao {
	/**
	 * <b>功能描述：查询用户资产列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzUserAssetByList(Map map); 
	
	public List<Map<String,Object>> queryJnzUserAsset(Map map);
	/**
	 * <b>功能描述：查询用户资产列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzUserAssetByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询用户资产信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserAssetById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID查询用户资产信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzUserAssetByUserId(@Param("userId")Integer userId);
	/**
	 * <b>功能描述：根据ID删除用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzUserAssetById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzUserAssetBySelective(JnzUserAsset jnzUserAsset);
	/**
	 * <b>功能描述：新增用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserAssetSelective(JnzUserAsset jnzUserAsset);
	/**
	 * <b>功能描述：新增用户资产
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzUserAsset(JnzUserAsset jnzUserAsset);
	
	    /**
     * 
     * 功能描述: 批量删除用户资产
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzUserAsset(Map<String, Object> paraMap);
    
    public Map<String, Object> queryUserProfitStatics();
}
