package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzShufflingFigure;


/**
 * <b>功能描述：广告轮播图Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzShufflingFigureDao {
	/**
	 * <b>功能描述：查询广告轮播图列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzShufflingFigureByList(Map map); 
	/**
	 * <b>功能描述：查询广告轮播图列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzShufflingFigureByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询广告轮播图信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzShufflingFigureById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzShufflingFigureById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzShufflingFigureBySelective(JnzShufflingFigure jnzShufflingFigure);
	/**
	 * <b>功能描述：新增广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzShufflingFigureSelective(JnzShufflingFigure jnzShufflingFigure);
	/**
	 * <b>功能描述：新增广告轮播图
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzShufflingFigure(JnzShufflingFigure jnzShufflingFigure);
	
	    /**
     * 
     * 功能描述: 批量删除广告轮播图
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzShufflingFigure(Map<String, Object> paraMap);
    /**
     * 
     * 功能描述: 通用获取广告或轮播图方法
     * 
     * @param paraMap
     * @return List<JnzShufflingFigure>
     * @date 2016-11-9
     * @since 1.0.0
     * @version 1.0.0
     * @author 徐大伟
     */
    public List<JnzShufflingFigure> getJnzShufflingFigureList(Map<String, Object> paraMap);
}
