package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.ync365.jrpt.business.dao.entity.JnzSearchWord;


/**
 * <b>功能描述：搜索词Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzSearchWordDao {
	/**
	 * <b>功能描述：查询搜索词列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzSearchWordByList(Map map); 
	/**
	 * <b>功能描述：查询搜索词列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzSearchWordByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询搜索词信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzSearchWordById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzSearchWordById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzSearchWordBySelective(JnzSearchWord jnzSearchWord);
	/**
	 * <b>功能描述：新增搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSearchWordSelective(JnzSearchWord jnzSearchWord);
	/**
	 * <b>功能描述：新增搜索词
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzSearchWord(JnzSearchWord jnzSearchWord);
	
	    /**
     * 
     * 功能描述: 批量删除搜索词
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzSearchWord(Map<String, Object> paraMap);
    /**
     * 
     * 功能描述:查询搜索历史
     * 
     * @return List<String>
     * @version 1.0.0
     * @author 徐大伟
     */
    public List<String> getSearchHistory();
}
