package com.ync365.jrpt.business.dao;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import com.ync365.jrpt.business.dao.entity.JnzProductInfo;


/**
 * <b>功能描述：理财产品Dao
 * 
 * @version V1.0.0
 * @author 徐大伟
 */ 
public interface JnzProductInfoDao {
	/**
	 * <b>功能描述：查询理财产品列表
	 
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public List<Map<String,Object>> queryJnzProductInfoByList(Map map); 
	/**
	 * <b>功能描述：查询理财产品列表总数
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 
	public Integer queryJnzProductInfoByCount(Map map); 
	/**
	 * <b>功能描述：根据ID查询理财产品信息
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */ 	
	public Map<String, Object>  queryJnzProductInfoById(@Param("id")Integer id); 
	/**
	 * 
	 * 功能描述: 
	 * 
	 * @param productId
	 * @return Map<String,Object>
	 * @date 2016-11-10
	 * @since 1.0.0
	 * @version 1.0.0
	 * @author 徐大伟
	 */
	public JnzProductInfo  getJnzProductInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：根据ID删除理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer deleteJnzProductInfoById(@Param("id")Integer id); 
	/**
	 * <b>功能描述：修改理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer updateJnzProductInfoBySelective(JnzProductInfo jnzProductInfo);
	/**
	 * <b>功能描述：新增理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductInfoSelective(JnzProductInfo jnzProductInfo);
	/**
	 * <b>功能描述：新增理财产品
	 * @version V1.0.0
	 * @author 徐大伟
	 * @param 
	 * @return 
	 */
	public Integer insertJnzProductInfo(JnzProductInfo jnzProductInfo);
	
	    /**
     * 
     * 功能描述: 批量删除理财产品
     * @param paraMap
     * @return int
	 * @version V1.0.0
	 * @author 徐大伟
     */
    public int batchDeleteJnzProductInfo(Map<String, Object> paraMap);
    /**
     * 
     * 功能描述: 搜索结果列表
     * 
     * @param paraMap
     * @return List<JnzProductInfo>
     * @version 1.0.0
     * @author 徐大伟
     */
    public List<JnzProductInfo> search(Map<String, Object> paraMap);
    /**
     * 
     * 功能描述: 搜索结果总数
     * 
     * @param paraMap
     * @return int
     * @version 1.0.0
     * @author 徐大伟
     */
    public int searchCount(Map<String, Object> paraMap);
    /**
     * <b>功能描述：查询理财产品列表(前台)
     
     * @version V1.0.0
     * @author 徐大伟
     * @param 
     * @return 
     */ 
    public List<JnzProductInfo> getProductInfoByList(Map<String, Object> paraMap);
}
